/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block;

import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.item.RemoteControl;
import me.srrapero720.waterframes.common.item.data.RemoteData;
import me.srrapero720.waterframes.common.screens.DisplayScreen;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6319;
import net.minecraft.class_6328;
import net.minecraft.class_9062;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.BlockGuiCreator;
import team.creative.creativecore.common.gui.creator.GuiCreator;

@class_6328
@class_6319
public abstract class DisplayBlock
extends class_2237
implements BlockGuiCreator,
class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 VISIBLE = new class_2746("frame"){};
    public static final class_2758 LIGHT_LEVEL = class_2741.field_12538;
    public static final class_2753 ATTACHED_FACE = class_2753.method_11845((String)"attached_face", (class_2350[])new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033});
    protected static final class_4970.class_2251 PROPERTIES = FabricBlockSettings.create().luminance(value -> (Integer)value.method_11654((class_2769)LIGHT_LEVEL)).strength(1.0f).method_9626(class_2498.field_11533).method_22488().method_51370().method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50012(class_3619.field_15971).method_29292();

    protected DisplayBlock() {
        super(PROPERTIES);
    }

    protected DisplayBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public abstract class_2753 getFacing();

    public String getPermissionNode() {
        return "waterframes.displays.interact";
    }

    public GuiLayer create(class_2487 tag, class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        DisplayScreen displayScreen;
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)class_25862;
            displayScreen = new DisplayScreen(tile);
        } else {
            displayScreen = null;
        }
        return displayScreen;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        RemoteData data = (RemoteData)stack.method_57824(DisplaysRegistry.REMOTE_DATA);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof RemoteControl) {
            RemoteControl control = (RemoteControl)class_17922;
            if (data != null) {
                class_2586 class_25862;
                boolean matchDim = control.getDimension(data).equals(level.method_27983().method_29177().toString());
                int[] position = control.getPosition(data);
                if (position.length == 0) {
                    return class_9062.field_47733;
                }
                boolean matchPos = new class_2338(position[0], position[1], position[2]).equals((Object)pos);
                if (matchDim && matchPos && (class_25862 = level.method_8321(pos)) instanceof DisplayTile) {
                    DisplayTile tile = (DisplayTile)class_25862;
                    if (level.field_9236) {
                        tile.setPause(true, !tile.data.paused);
                    }
                    class_243 vec = class_243.method_24953((class_2382)pos);
                    class_2390 opts = new class_2390(new Vector3f((Vector3fc)class_243.method_24457((int)class_124.field_1075.method_532()).method_46409()), 1.3f);
                    int i = 0;
                    do {
                        level.method_8406((class_2394)opts, vec.field_1352 + this.randomNegative(Math.random()) / 4.0, vec.field_1351, vec.field_1350 + this.randomNegative(Math.random()) / 4.0, this.randomNegative(Math.random()), Math.random() * 3.0, this.randomNegative(Math.random()));
                    } while (++i < 4);
                    return class_9062.field_47728;
                }
            }
        }
        if (!level.field_9236 && DisplaysConfig.canInteractBlock(player, this)) {
            GuiCreator.BLOCK_OPENER.open(player, pos);
        }
        return class_9062.field_47728;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!level.field_9236 && DisplaysConfig.canInteractBlock(player, this)) {
            GuiCreator.BLOCK_OPENER.open(player, pos);
        }
        return class_1269.field_5812;
    }

    public boolean canConnectRedstone(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return state.method_11654((class_2769)this.getFacing()) == direction;
    }

    private double randomNegative(double v) {
        return Math.random() > 0.5 ? -v : v;
    }

    public void method_9590(class_2680 state) {
        super.method_9590((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(new class_2769[]{this.getFacing(), ATTACHED_FACE, POWERED, WATERLOGGED}).method_11667(new class_2769[]{LIGHT_LEVEL}));
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 current = context.method_8042();
        class_1657 player = context.method_8036();
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ATTACHED_FACE, (Comparable)context.method_8038())).method_11657((class_2769)this.getFacing(), (Comparable)(player != null && player.method_18276() ? current.method_10153() : current));
    }

    public class_2464 method_9604(class_2680 state) {
        return state.method_28498((class_2769)VISIBLE) ? (((Boolean)state.method_11654((class_2769)VISIBLE)).booleanValue() ? class_2464.field_11458 : class_2464.field_11455) : class_2464.field_11458;
    }

    public class_265 method_9584(class_2680 state, class_1922 level, class_2338 pos) {
        return this.method_9530(state, level, pos, null);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> type) {
        return (l, pos, state, be) -> {
            if (be instanceof DisplayTile) {
                DisplayTile tile = (DisplayTile)be;
                tile.method_31662(l);
                tile.tick(state);
            }
        };
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 neighborPos, boolean isMoving) {
        class_2586 class_25862;
        super.method_9612(state, level, pos, block, neighborPos, isMoving);
        if (!DisplaysConfig.useRedstone() || !((class_25862 = level.method_8321(pos)) instanceof DisplayTile)) {
            return;
        }
        DisplayTile tile = (DisplayTile)class_25862;
        boolean signal = level.method_49803(pos);
        if ((Boolean)state.method_11654((class_2769)POWERED) != signal) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(signal)), 3);
            if (!level.field_9236) {
                tile.setPause(false, signal);
            }
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        int n;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)class_25862;
            n = tile.getAnalogOutput();
        } else {
            n = 0;
        }
        return n;
    }

    public float method_9575(class_2680 state, class_1922 level, class_2338 pos) {
        return 0.0f;
    }

    public boolean method_37403(class_2680 pState, class_1922 pLevel, class_2338 pPos) {
        return false;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(true) : super.method_9545(state);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)this.getFacing(), (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)this.getFacing())));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)this.getFacing(), (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)this.getFacing())));
    }
}

